import random

import gymnasium as gym


def make_vec_envs(env_name, max_episode_steps, 
                  num_processes):
    """
    :param ret_rms: running return and std for rewards
    """
    # SyncVectorEnv for sequential execution, or AsyncVectorEnv for parallel execution
    envs = gym.vector.AsyncVectorEnv(
                [
                    lambda: gym.make(env_name,
                        max_episode_steps=max_episode_steps)
                    for _ in range(num_processes)
                ]
            )
    
    return envs